document.body.onload = function () {
    // load doms
    LOAD_LAST_EMAILS();
    LOAD_SMTPS();
    LOAD_LEADS();
    FROM_USER_GET();
    FROM_DOMAIN_GET();
    LINKS_GET();
    LOAD_MSGS();
    LOAD_PROFILES();
    // load selected profile
    LOAD_SELECTED_PROFILE();
    // set selects showhide
    // POST_PROFILE_SELECT();
    // 
    ACTIVATE_AUTO_SAVE();
    // 
}
// 
function POST_PROFILE_SELECT() {
    LAST_EMAIL_SELECT();
    SMTP_SELECT();
    SMTP_GET();
    // 
    if (DOC("SEND_TYPE").value === "SINGLE") {
        DOC("BCC_ID").classList.add("hide");
        DOC("BCC_TO").classList.add("hide");
    } else {
        if (DOC("LINK_EXTRA_SELECT").value === "QSA") {
            DOC("BCC_ID").classList.remove("hide");
        }
        DOC("BCC_TO").classList.remove("hide");
    }
    // 
    if (DOC("LINK_EXTRA_SELECT").value === "QSA") {
        if (DOC("SEND_TYPE").value === "BCC") { DOC("BCC_ID").classList.remove("hide"); }
        DOC("LINK_TRACK_DIV").classList.remove("hide");
        // 
    } else {
        DOC("BCC_ID").classList.add("hide");
        DOC("LINK_TRACK_DIV").classList.add("hide");
    }
    // 
    FROM_USER_SELECT();
    FROM_DOMAIN_SELECT();
    LINK_SELECT();
    MSG_SELECT();
}
//!
function ACTIVATE_AUTO_SAVE() {
    const settings_items = document.getElementsByName("SET");
    settings_items.forEach((element) => {
        if (element.type === "button") {
            element.addEventListener("click", SAVE_SELECTED_PROFILE);
        } else {
            element.addEventListener("change", SAVE_SELECTED_PROFILE);
        }
    });
    const smtp_settings_items = document.getElementsByName("SMTP_SET");
    smtp_settings_items.forEach((element) => {
        if (element.type === "button") {
            element.addEventListener("click", SMTP_SAVE);
        } else {
            element.addEventListener("change", SMTP_SAVE);
        }
    });
}
function RESET_SMTP_PROFILE() {
    const settings_items = document.getElementsByName("SMTP_SET");
    settings_items.forEach((element) => {
        const TAG = element.tagName.toLowerCase();
        if (TAG === "input") {
            const TYPE = element.type.toLowerCase();
            if (TYPE === "text") {
                element.value = "";
            }
            if (TYPE === "checkbox") {
                element.checked = false;
            }
        }
        if (TAG === "select") {
            element.value = element.options[0].value;
        }
        if (TAG === "label") {
            element.innerHTML = "0";
        }
    });
}
function RESET_INPUTS() {
    const settings_items = document.getElementsByName("SET");
    settings_items.forEach((element) => {
        const TAG = element.tagName.toLowerCase();
        if (TAG === "input") {
            const TYPE = element.type.toLowerCase();
            if (TYPE === "text") {
                element.value = "";
            }
            if (TYPE === "checkbox") {
                element.checked = false;
            }
        }
        if (TAG === "select") {
            element.value = element.options[0].value;
        }
        if (TAG === "label") {
            element.innerHTML = "0";
        }
    });
}
//!
function LOAD_PROFILES() {
    XHR("LOAD_PROFILES", false, "html/process.php", function (Resp) {
        if (Resp) {
            let Req_Json = JSON.parse(Resp);
            if (Req_Json !== undefined) {
                Object.entries(Req_Json).forEach(([PROFILE_NAME, PROFILE_ARRAY]) => {
                    let option = document.createElement("option");
                    option.text = PROFILE_NAME;
                    option.value = PROFILE_NAME;
                    DOC("PROFILE_SELECT").add(option);
                    if (PROFILE_ARRAY.SELECTED === true) {
                        DOC("PROFILE_SELECT").value = PROFILE_NAME;
                    }
                });
            }
        }
    });
}
DOC("PROFILE_SELECT").onchange = function () {
    PROFILE_SELECT();
}
function PROFILE_SELECT() {
    const NAME = DOC("PROFILE_SELECT").value;
    if (NAME === "EMPTY") {
        RESET_INPUTS();
        DOC("PROFILE_BTNS_DIV").classList.add("hide");
        DOC("PROFILE_NEW_DIV").classList.remove("hide");
    } else {
        DOC("PROFILE_BTNS_DIV").classList.remove("hide");
        DOC("PROFILE_NEW_DIV").classList.add("hide");
        LOAD_SELECTED_PROFILE();
        SAVE_SELECTED_PROFILE();
    }
}
function SAVE_SELECTED_PROFILE() {
    const settings_items = document.getElementsByName("SET");
    const PROFILE_NAME = DOC("PROFILE_SELECT").value;
    if (PROFILE_NAME === "EMPTY") {
        return false;
    }
    var data = "PROFILE_SAVE" + "&NAME=" + PROFILE_NAME;
    settings_items.forEach((element) => {
        const TAG = element.tagName.toLowerCase();
        if (TAG === "input") {
            const TYPE = element.type.toLowerCase();
            if (TYPE === "text" || TYPE === "button") {
                if (element.value !== "EMPTY" && element.value !== "") {
                    data += "&" + element.id + "=" + element.value;
                }
            } else if (TYPE === "checkbox") {
                data += "&" + element.id + "=" + element.checked;
            }
        } else if (TAG === "select") {
            if (element.value !== "EMPTY" && element.value !== "") {
                data += "&" + element.id + "=" + element.value;
            }
        }
    });
    // 
    XHR(data, false, "html/process.php", function (Resp) {
        if (Resp === "Done") {
            NOTIFY("Saved");
        }

    });
}
function LOAD_SELECTED_PROFILE() {
    RESET_INPUTS();
    READ_COUNT();
    XHR("LOAD_PROFILES", false, "html/process.php", function (Resp) {
        if (Resp) {
            let Req_Json = JSON.parse(Resp);
            if (Req_Json !== undefined) {
                Object.entries(Req_Json).forEach(([PROFILE_NAME, PROFILE_ARRAY]) => {
                    if (PROFILE_NAME === DOC("PROFILE_SELECT").value) {
                        DOC("PROFILE_SELECT_DIV").classList.remove("hide");
                        DOC("PROFILE_BTNS_DIV").classList.remove("hide");
                        DOC("PROFILE_NEW_DIV").classList.add("hide");
                        Object.entries(PROFILE_ARRAY).forEach(
                            ([SETTING_NAME, SETTING_VALUE]) => {
                                if (DOC(SETTING_NAME) !== null) {
                                    const TAG = DOC(SETTING_NAME).tagName.toLowerCase();
                                    if (TAG === "input") {
                                        const TYPE = DOC(SETTING_NAME).type.toLowerCase();
                                        if (TYPE === "text" || TYPE === "button") {
                                            DOC(SETTING_NAME).value = SETTING_VALUE;
                                        }
                                        if (TYPE === "checkbox") {
                                            if (SETTING_VALUE === "true") {
                                                DOC(SETTING_NAME).checked = true;
                                            } else {
                                                DOC(SETTING_NAME).checked = false;
                                            }
                                        }
                                    } else if (TAG === "select") {
                                        let FOUND = false;
                                        for (let index = 0; index < DOC(SETTING_NAME).options.length; index++) {
                                            if (DOC(SETTING_NAME).options[index].value === SETTING_VALUE) {
                                                DOC(SETTING_NAME).value = SETTING_VALUE;
                                                FOUND = true;
                                                break;
                                            }
                                        }
                                        if (!FOUND) {
                                            DOC(SETTING_NAME).value = DOC(SETTING_NAME).options[0].value;
                                        }
                                    } else if (TAG === "label") {
                                        DOC(SETTING_NAME).innerHTML = SETTING_VALUE;
                                    }
                                }
                            }
                        );
                    }
                });
            }
        }
    });
    // 
    POST_PROFILE_SELECT();
    // 
}
DOC("PROFILE_ADD").onclick = function () {
    const PROFILE_NAME = DOC("PROFILE_INPUT").value.trim();
    if (PROFILE_NAME !== "") {
        XHR("PROFILE_ADD" + "&NAME=" + PROFILE_NAME, true, "html/process.php", function (Resp) {
            if (Resp === "Done") {
                let option = document.createElement("option");
                option.text = PROFILE_NAME;
                option.value = PROFILE_NAME;
                DOC("PROFILE_SELECT").add(option);
                DOC("PROFILE_SELECT").value = PROFILE_NAME;
                DOC("PROFILE_INPUT").value = "";
                DOC("PROFILE_SELECT_DIV").classList.remove("hide");
                DOC("PROFILE_BTNS_DIV").classList.remove("hide");
                DOC("PROFILE_NEW_DIV").classList.add("hide");
                PROFILE_SELECT();
                NOTIFY(PROFILE_NAME + " Added");
            }
        });
    }
}
DOC("PROFILE_DEL").onclick = function () {
    const PROFILE_NAME = DOC("PROFILE_SELECT").value;
    if (PROFILE_NAME !== "") {
        XHR("PROFILE_DEL" + "&NAME=" + PROFILE_NAME, true, "html/process.php", function (Resp) {
            if (Resp === "Done") {
                DOC("PROFILE_SELECT").remove(DOC("PROFILE_SELECT").selectedIndex);
                DOC("PROFILE_SELECT").value = DOC("PROFILE_SELECT").options[0].value;
                PROFILE_SELECT();
                NOTIFY(PROFILE_NAME + " Removed");
            }
        });
    }
}
// 
DOC("RESET_TOTAL").onclick = function () {
    RESET_COUNT(true, false);
};
function RESET_COUNT(TOTAL = false, RECENT = false) {
    let DATA = "RESET_COUNT&NAME=" + DOC("PROFILE_SELECT").value;
    if (TOTAL) {
        DATA += "&TOTAL";
    }
    if (RECENT) {
        DATA += "&RECENT";
    }
    // 
    XHR(DATA, true, "SEND.php", function (Resp) {
        if (Resp === "Done") {
            if (TOTAL) {
                DOC("SENT_TOTAL").innerHTML = "0";
            }
            if (RECENT) {
                DOC("SENT_RECENT").innerHTML = "0";
            }
        }
    });
    // 
}
function READ_COUNT() {
    XHR("GET_COUNT&NAME=" + DOC("PROFILE_SELECT").value, true, "SEND.php", function (Resp) {
        let Req_Json = JSON.parse(Resp);
        if (Req_Json !== undefined) {
            DOC("SENT_TOTAL").innerHTML = Req_Json.TOTAL;
            DOC("SENT_RECENT").innerHTML = Req_Json.RECENT;
        }
    });
}
// 
DOC("SEND_TYPE").onchange = function () {
    if (this.value === "BCC") {
        DOC("BCC_TO").classList.remove("hide");
        if (DOC("LINK_EXTRA_SELECT").value === "QSA") {
            DOC("BCC_ID").classList.remove("hide");
        }
    } else {
        DOC("BCC_ID").classList.add("hide");
        DOC("BCC_TO").classList.add("hide");
    }
}
// 
DOC("LAST_EMAIL_SELECT").onchange = function () {
    LAST_EMAIL_SELECT();
}
function LAST_EMAIL_SELECT() {
    const EMAIL = DOC("LAST_EMAIL_SELECT").value;
    if (EMAIL === "EMPTY") {
        DOC("LAST_EMAIL_NEW_DIV").classList.remove("hide");
        DOC("LAST_EMAIL_BTNS_DIV").classList.add("hide");
        // 
    } else {
        DOC("LAST_EMAIL_NEW_DIV").classList.add("hide");
        DOC("LAST_EMAIL_BTNS_DIV").classList.remove("hide");
    }
}
DOC("LAST_EMAIL_ADD").onclick = function () {
    const EMAIL = DOC("LAST_EMAIL_INPUT").value;
    if (EMAIL !== "") {
        XHR("LAST_EMAIL_ADD&EMAIL=" + EMAIL, true, "html/process.php", function (Resp) {
            if (Resp === "Done") {
                let option = document.createElement("option");
                option.text = EMAIL;
                option.value = EMAIL;
                DOC("LAST_EMAIL_SELECT").add(option);
                DOC("LAST_EMAIL_SELECT").value = EMAIL;
                LAST_EMAIL_SELECT();
                NOTIFY(EMAIL + " Added");
                SAVE_SELECTED_PROFILE();
                // 
                DOC("LAST_EMAIL_NEW_DIV").classList.add("hide");
                DOC("LAST_EMAIL_INPUT").value = "";
            } else {
                NOTIFY(Resp);
            }
        });
    }
}
DOC("LAST_EMAIL_DEL").onclick = function () {
    const EMAIL = DOC("LAST_EMAIL_SELECT").value;
    if (EMAIL !== "EMPTY") {
        XHR("LAST_EMAIL_DEL&EMAIL=" + EMAIL, true, "html/process.php", function (Resp) {
            if (Resp === "Done") {
                DOC("LAST_EMAIL_SELECT").remove(DOC("LAST_EMAIL_SELECT").selectedIndex);
                DOC("LAST_EMAIL_SELECT").value = DOC("LAST_EMAIL_SELECT").options[0].value;
                LAST_EMAIL_SELECT();
                SAVE_SELECTED_PROFILE();
                NOTIFY(EMAIL + " Removed");
            }
        });
    }
}
function LOAD_LAST_EMAILS() {
    XHR("LOAD_LAST_EMAILS", false, "html/process.php", function (Resp) {
        if (Resp) {
            let Req_Json = JSON.parse(Resp);
            if (Req_Json !== undefined) {
                Req_Json.forEach((email) => {
                    let option = document.createElement("option");
                    option.text = email;
                    option.value = email;
                    DOC("LAST_EMAIL_SELECT").add(option);
                });
            }
        }
    });
}
// 
DOC("LEADS_RELOAD").onclick = function () {
    LOAD_LEADS();
}
function LOAD_LEADS() {
    XHR("LOAD_LEADS", false, "html/process.php", function (Resp) {
        if (Resp) {
            let Req_Json = JSON.parse(Resp);
            if (Req_Json !== undefined) {
                const PREV_SELECTED = DOC("LEADS_FILE").value;
                DOC("LEADS_FILE").innerHTML = "";
                let option = document.createElement("option");
                option.text = "- Leads -";
                option.value = "EMPTY";
                DOC("LEADS_FILE").add(option);
                // 
                Req_Json.forEach((LEADS_NAME) => {
                    let option = document.createElement("option");
                    option.text = LEADS_NAME.TEXT + " :" + LEADS_NAME.COUNT;
                    option.value = LEADS_NAME.VALUE;
                    DOC("LEADS_FILE").add(option);
                });
                DOC("LEADS_FILE").value = PREV_SELECTED;
            }
        }
    });
}
// 
DOC("SMTP_SERVER_HINT").onchange = function () {
    const HINT = DOC("SMTP_SERVER_HINT").value;
    DOC("SMTP_SERVER").value = HINT;
    DOC("SMTP_SERVER_HINT").value = DOC("SMTP_SERVER_HINT").options[0].value;
    SMTP_SAVE();
}

DOC("SMTP_SELECT").onchange = function () {
    RESET_SMTP_PROFILE();
    SMTP_SELECT();
}
DOC("SMTP_EDIT").onclick = function () {
    DOC("SMTP_INPUTS_DIV").classList.toggle("hide");
}
function SMTP_SELECT(NEW = false) {
    const SMTP = DOC("SMTP_SELECT").value;
    // DOC("SMTP_INPUTS_DIV").classList.add("hide");
    if (SMTP === "EMPTY") {
        DOC("SMTP_BTNS_DIV").classList.add("hide");
        DOC("SMTP_INPUTS_DIV").classList.add("hide");
        DOC("SMTP_NEW_DIV").classList.remove("hide");
    } else {
        if (NEW) {
            DOC("SMTP_INPUTS_DIV").classList.remove("hide");
        } else {
            SMTP_GET();
        }
        DOC("SMTP_BTNS_DIV").classList.remove("hide");
        DOC("SMTP_NEW_DIV").classList.add("hide");
    }
}
function SMTP_GET() {
    const NAME = DOC("SMTP_SELECT").value;
    if (NAME !== "") {
        XHR("SMTP_GET&NAME=" + NAME, true, "html/process.php", function (Resp) {
            let Req_Json = JSON.parse(Resp);
            if (Req_Json !== undefined) {
                if (undefined !== Req_Json.COUNT) {
                    DOC("SMTP_SELECT").options[
                        DOC("SMTP_SELECT").options.selectedIndex
                    ].text = DOC("SMTP_SELECT").value + " :" + Req_Json.COUNT;
                }
                if (undefined !== Req_Json.SERVER) {
                    DOC("SMTP_SERVER").value = Req_Json.SERVER;
                } else { DOC("SMTP_SERVER").value = ""; }
                if (undefined !== Req_Json.PORT) {
                    DOC("SMTP_PORT_SELECT").value = Req_Json.PORT;
                } else { DOC("SMTP_PORT_SELECT").value = DOC("SMTP_PORT_SELECT").options[0].value; }
                if (undefined !== Req_Json.SECURE) {
                    DOC("SMTP_ENC_SELECT").value = Req_Json.SECURE;
                } else { DOC("SMTP_ENC_SELECT").value = DOC("SMTP_ENC_SELECT").options[0].value; }
                if (undefined !== Req_Json.AUTH) {
                    DOC("SMTP_AUTH_SELECT").value = Req_Json.AUTH;
                } else { DOC("SMTP_AUTH_SELECT").value = DOC("SMTP_AUTH_SELECT").options[0].value; }
            }
        });
    }
}
DOC("USERS_FILE_CLICK").onclick = function () {
    DOC("SMTP_USERS_FILE").click();
}
DOC("SMTP_USERS_FILE").onchange = function () {
    var reader = new FileReader();
    reader.onload = function () {
        let File_data = reader.result;
        // console.log(File_data);
        const NAME = DOC("SMTP_SELECT").value;
        XHR("SMTP_USER_FILE_ADD&NAME=" + NAME + "&DATA=" + File_data, true, "html/process.php", function (Resp) {
            if (Resp) {
                let Req_Json = JSON.parse(Resp);
                if (Req_Json !== undefined) {
                    NOTIFY(Req_Json.ADDED + " Added<br>" + Req_Json.TOTAL + " Total");
                    DOC("SMTP_SELECT").options[
                        DOC("SMTP_SELECT").options.selectedIndex
                    ].text = DOC("SMTP_SELECT").value + " :" + Req_Json.TOTAL;
                }
                DOC("SMTP_USERS_FILE").value = "";
            }
        });
    };
    reader.readAsText(this.files[0]);
}
DOC("SMTP_USER_ADD").onclick = function () {
    SMTP_USER_ADD();
}
function SMTP_USER_ADD() {
    const NAME = DOC("SMTP_SELECT").value;
    const USER = DOC("SMTP_USER").value;
    const PASS = DOC("SMTP_PASS").value;
    if (NAME === "" || USER === "" || PASS === "") {
        return false;
    }
    XHR("SMTP_USER_ADD" + "&NAME=" + NAME + "&USER=" + USER + "&PASS=" + PASS
        , true, "html/process.php", function (Resp) {
            if (Resp !== "Exist") {
                DOC("SMTP_SELECT").options[
                    DOC("SMTP_SELECT").options.selectedIndex
                ].text = DOC("SMTP_SELECT").value + " :" + Resp;
                DOC("SMTP_USER").value = "";
                DOC("SMTP_PASS").value = "";
                NOTIFY(USER + " Added");
            } else {
                NOTIFY(USER + " Already Exist");
            }
        });
}
DOC("SMTP_ADD").onclick = function () {
    const NAME = DOC("SMTP_NAME").value;
    if (NAME !== "") {
        XHR("SMTP_ADD&NAME=" + NAME, true, "html/process.php", function (Resp) {
            if (Resp === "Added") {
                let option = document.createElement("option");
                option.text = NAME;
                option.value = NAME;
                DOC("SMTP_SELECT").add(option);
                DOC("SMTP_SELECT").value = NAME;
                SMTP_SELECT(true);
                NOTIFY(NAME + " Added");
                SAVE_SELECTED_PROFILE();
                // 
                DOC("SMTP_NAME").value = "";
            } else {
                NOTIFY(Resp);
            }
        });
    }
}
function SMTP_SAVE() {
    const NAME = DOC("SMTP_SELECT").value;
    const SERVER = DOC("SMTP_SERVER").value;
    const PORT = DOC("SMTP_PORT_SELECT").value;
    const SECURE = DOC("SMTP_ENC_SELECT").value;
    const AUTH = DOC("SMTP_AUTH_SELECT").value;
    if (NAME === "EMPTY") {
        return false;
    }
    XHR("SMTP_SAVE" +
        "&NAME=" +
        NAME +
        "&SERVER=" +
        SERVER +
        "&PORT=" +
        PORT +
        "&SECURE=" +
        SECURE +
        "&AUTH=" +
        AUTH,
        true, "html/process.php", function (Resp) {
            if (Resp === "Done") {
                NOTIFY(NAME + " Saved");
            }
        });
}
DOC("SMTP_RESET").onclick = function () {
    const SELECTED = DOC("SMTP_SELECT").value;
    if (SELECTED === "EMPTY") {
        return false;
    }
    XHR("SMTP_RESET&NAME=" + SELECTED, true, "html/process.php", function (Resp) {
        if (Resp) {
            DOC("SMTP_SELECT").options[
                DOC("SMTP_SELECT").options.selectedIndex
            ].text = DOC("SMTP_SELECT").value + " :" + Resp;
            NOTIFY(SELECTED + " Reset Done");
        }
    });
}
DOC("SMTP_DEL").onclick = function () {
    const SELECTED = DOC("SMTP_SELECT").value;
    if (SELECTED === "EMPTY") {
        return false;
    }
    if (confirm("Remove: " + SELECTED)) {
        XHR("SMTP_DEL&NAME=" + SELECTED, true, "html/process.php", function (Resp) {
            if (Resp === "Done") {
                DOC("SMTP_SELECT").remove(DOC("SMTP_SELECT").selectedIndex);
                DOC("SMTP_SELECT").value = DOC("SMTP_SELECT").options[0].value;
                NOTIFY(SELECTED + " Deleted");
                RESET_SMTP_PROFILE();
                SMTP_SELECT();
                SAVE_SELECTED_PROFILE();
            }
        });
    }
}
function LOAD_SMTPS() {
    XHR("LOAD_SMTPS", false, "html/process.php", function (Resp) {
        if (Resp) {
            let Req_Json = JSON.parse(Resp);
            if (Req_Json !== undefined) {
                DOC("SMTP_SELECT").innerHTML = '';
                Req_Json.forEach((smtp) => {
                    let option = document.createElement("option");
                    option.text = smtp.TEXT;
                    option.value = smtp.VALUE;
                    DOC("SMTP_SELECT").add(option);
                });
            }
        }
    });
}
// 
DOC("FROM_RELOAD").onclick = function () {
    FROM_USER_GET();
    FROM_DOMAIN_GET();
}
// 
DOC("FROM_USER_SELECT").onchange = function () {
    FROM_USER_SELECT();
}
function FROM_USER_SELECT() {
    const SELECTED = DOC("FROM_USER_SELECT").value;
    if (SELECTED === "Input") {
        DOC("FROM_USER_INPUT").classList.remove("hide");
    } else {
        DOC("FROM_USER_INPUT").classList.add("hide");
        if (SELECTED === "") {
            DOC("FROM_USER_SELECT").value = DOC("FROM_USER_SELECT").options[0].value;
        }
    }
}
function FROM_USER_GET() {
    XHR("FROM_USER_GET", false, "html/process.php", function (Resp) {
        if (Resp) {
            let Req_Json = JSON.parse(Resp);
            if (Req_Json !== undefined) {
                const PREV_SELECTED = DOC("FROM_USER_SELECT").value;
                DOC("FROM_USER_SELECT").innerHTML = "";
                let option = document.createElement("option");
                option.text = "-From USER";
                option.value = "EMPTY";
                DOC("FROM_USER_SELECT").add(option);
                option = document.createElement("option");
                option.text = "Input 👉";
                option.value = "Input";
                DOC("FROM_USER_SELECT").add(option);
                option = document.createElement("option");
                option.text = "SMTP User";
                option.value = "SMTP_USER";
                DOC("FROM_USER_SELECT").add(option);
                option = document.createElement("option");
                option.text = "Hash";
                option.value = "Hash";
                DOC("FROM_USER_SELECT").add(option);
                option = document.createElement("option");
                option.text = "Random";
                option.value = "Random";
                DOC("FROM_USER_SELECT").add(option);
                option = document.createElement("option");
                option.text = "Random Word";
                option.value = "Random_Word";
                DOC("FROM_USER_SELECT").add(option);
                option = document.createElement("option");
                option.text = "-Files- 👇";
                option.value = "";
                DOC("FROM_USER_SELECT").add(option);
                // 
                Req_Json.forEach((FILE_NAME) => {
                    let option = document.createElement("option");
                    option.text = FILE_NAME.VALUE + " :" + FILE_NAME.COUNT;
                    option.value = FILE_NAME.VALUE;
                    DOC("FROM_USER_SELECT").add(option);
                });
                DOC("FROM_USER_SELECT").value = PREV_SELECTED;
            }
        }
    });
}
// 
DOC("FROM_DOMAIN_SELECT").onchange = function () {
    FROM_DOMAIN_SELECT();
}
function FROM_DOMAIN_SELECT() {
    const SELECTED = DOC("FROM_DOMAIN_SELECT").value;
    if (SELECTED === "Input") {
        DOC("FROM_DOMAIN_INPUT").classList.remove("hide");
    } else {
        DOC("FROM_DOMAIN_INPUT").classList.add("hide");
        if (SELECTED === "") {
            DOC("FROM_DOMAIN_SELECT").value = DOC("FROM_DOMAIN_SELECT").options[0].value;
        }
    }
}
function FROM_DOMAIN_GET() {
    XHR("FROM_DOMAIN_GET", false, "html/process.php", function (Resp) {
        if (Resp) {
            let Req_Json = JSON.parse(Resp);
            if (Req_Json !== undefined) {
                const PREV_SELECTED = DOC("FROM_DOMAIN_SELECT").value;
                DOC("FROM_DOMAIN_SELECT").innerHTML = "";
                let option = document.createElement("option");
                option.text = "-From DOMAIN";
                option.value = "EMPTY";
                DOC("FROM_DOMAIN_SELECT").add(option);
                option = document.createElement("option");
                option.text = "Input 👉";
                option.value = "Input";
                DOC("FROM_DOMAIN_SELECT").add(option);
                option = document.createElement("option");
                option.text = "SMTP Domain";
                option.value = "SMTP_Domain";
                DOC("FROM_DOMAIN_SELECT").add(option);
                option = document.createElement("option");
                option.text = "-Files- 👇";
                option.value = "";
                DOC("FROM_DOMAIN_SELECT").add(option);
                // 
                Req_Json.forEach((FILE_NAME) => {
                    let option = document.createElement("option");
                    option.text = FILE_NAME.VALUE + " :" + FILE_NAME.COUNT;
                    option.value = FILE_NAME.VALUE;
                    DOC("FROM_DOMAIN_SELECT").add(option);
                });
                DOC("FROM_DOMAIN_SELECT").value = PREV_SELECTED;
            }
        }
    });
}
// 
DOC("LINK_SELECT").onchange = function () { LINK_SELECT(); }
function LINK_SELECT() {
    const SELECTED = DOC("LINK_SELECT").value;
    if (SELECTED === "Input") {
        DOC("LINK_INPUT").classList.remove("hide");
        DOC("LINK_SELECT").setAttribute("style", "max-width:max-content;");
    } else {
        DOC("LINK_SELECT").setAttribute("style", "");
        DOC("LINK_INPUT").classList.add("hide");
        if (SELECTED === "") {
            DOC("LINK_SELECT").value = DOC("LINK_SELECT").options[0].value;
        }
    }
}
DOC("LINKS_RELOAD").onclick = function () { LINKS_GET(); }
function LINKS_GET() {
    XHR("LINKS_GET", false, "html/process.php", function (Resp) {
        if (Resp) {
            let Req_Json = JSON.parse(Resp);
            if (Req_Json !== undefined) {
                const PREV_SELECTED = DOC("LINK_SELECT").value;
                DOC("LINK_SELECT").innerHTML = "";
                let option = document.createElement("option");
                option.text = "-LINKS";
                option.value = "EMPTY";
                DOC("LINK_SELECT").add(option);
                option = document.createElement("option");
                option.text = "Input 👉";
                option.value = "Input";
                DOC("LINK_SELECT").add(option);
                option = document.createElement("option");
                option.text = "-Files- 👇";
                option.value = "";
                DOC("LINK_SELECT").add(option);
                // 
                Req_Json.forEach((FILE_NAME) => {
                    let option = document.createElement("option");
                    option.text = FILE_NAME.VALUE + " :" + FILE_NAME.COUNT;
                    option.value = FILE_NAME.VALUE;
                    DOC("LINK_SELECT").add(option);
                });
                DOC("LINK_SELECT").value = PREV_SELECTED;
            }
        }
    });
}
// 
DOC("LINK_EXTRA_SELECT").onchange = function () {
    const SELECTED = DOC("LINK_EXTRA_SELECT").value;
    if (SELECTED === "QSA") {
        if (DOC("SEND_TYPE").value === "BCC") {
            DOC("BCC_ID").classList.remove("hide");
        }
        DOC("LINK_TRACK_DIV").classList.remove("hide");
        // 
    } else {
        DOC("BCC_ID").classList.add("hide");
        DOC("LINK_TRACK_DIV").classList.add("hide");
    }
}
// 
DOC("MSGS_RELOAD").onclick = function () {
    LOAD_MSGS();
}
function LOAD_MSGS() {
    XHR("LOAD_MSGS", false, "html/process.php", function (Resp) {
        if (Resp) {
            let Req_Json = JSON.parse(Resp);
            if (Req_Json !== undefined) {
                const PREV_SELECTED = DOC("MSG_FILE").value;
                DOC("MSG_FILE").innerHTML = "";
                let option = document.createElement("option");
                option.text = "-[New MSG]-";
                option.value = "EMPTY";
                DOC("MSG_FILE").add(option);
                // 
                Req_Json.forEach((MSG_NAME) => {
                    let option = document.createElement("option");
                    option.text = MSG_NAME.VALUE;
                    option.value = MSG_NAME.VALUE;
                    DOC("MSG_FILE").add(option);
                });
                DOC("MSG_FILE").value = PREV_SELECTED;
            }
        }
    });
}
DOC("MSG_FILE").onchange = function () { MSG_SELECT(); }
function MSG_SELECT() {
    // 
    DOC("MSG_IFRAME").src = "";
    DOC("MSG_INPUT").value = "";
    const SELECTED = DOC("MSG_FILE").value;
    if (SELECTED === "EMPTY") {
        DOC("MSG_FILE_NAME").classList.remove("hide");
        DOC("MSG_DEL").classList.add("hide");
        DOC("MSG_TOGGLE").classList.add("hide");

        DOC("MSG_TOGGLE").value = "View";
        DOC("MSG_IFRAME").classList.add("hide");
        DOC("MSG_INPUT").classList.remove("hide");
    } else {
        DOC("MSG_FILE_NAME").classList.add("hide");
        DOC("MSG_DEL").classList.remove("hide");
        DOC("MSG_TOGGLE").classList.remove("hide");
        // 
        DOC("MSG_IFRAME").src = "Data/MSGS/" + SELECTED;
        MSG_GET();
        // 
    }
}
function MSG_GET() {
    const SELECTED = DOC("MSG_FILE").value;
    XHR("MSG_GET&NAME=" + SELECTED, false, "html/process.php", function (Resp) {
        if (Resp) {
            DOC("MSG_INPUT").value = Resp;
        }
    });
}
DOC("MSG_SAVE").onclick = function () { MSG_SAVE(); }
function MSG_SAVE() {
    var NEW = false;
    var FILE = "";
    var MSG_DATA = DOC("MSG_INPUT").value;
    var DATA = "MSG_SAVE&NAME=";
    var SELECTED = DOC("MSG_FILE").value;
    var FILE_INPUT = DOC("MSG_FILE_NAME").value;
    if (FILE_INPUT !== "" && SELECTED !== FILE_INPUT) {
        FILE = FILE_INPUT;
        DATA += FILE_INPUT;
        NEW = true;
    } else {
        FILE = SELECTED;
        DATA += SELECTED;
    }
    DATA += "&DATA=" + encodeURIComponent(MSG_DATA);
    // 
    XHR(DATA, false, "html/process.php", function (Resp) {
        DOC("MSG_IFRAME").src = "";
        DOC("MSG_IFRAME").src = "Data/MSGS/" + FILE;
        if (Resp === "Updated") {

        }
        if (Resp === "Added") {
            const option = document.createElement("option");
            option.text = FILE;
            option.value = FILE;
            DOC("MSG_FILE").add(option);
            DOC("MSG_FILE").value = FILE;
            DOC("MSG_FILE_NAME").value = "";

        }
        MSG_SELECT();
        SAVE_SELECTED_PROFILE();
        NOTIFY(Resp);
    });
    // 
}
DOC("MSG_DEL").onclick = function () {
    var SELECTED = DOC("MSG_FILE").value;
    if (confirm("Delete " + SELECTED)) {
        XHR("MSG_DEL&NAME=" + SELECTED, false, "html/process.php", function (Resp) {
            if (Resp === "Done") {
                DOC("MSG_FILE").remove(DOC("MSG_FILE").selectedIndex);
                DOC("MSG_FILE").value = DOC("MSG_FILE").options[0].value;
                MSG_SELECT();
                SAVE_SELECTED_PROFILE();
            }
        });
    }
}

DOC("MSG_TOGGLE").onclick = function () {
    MSG_SELECT();
    if (this.value === "View") {
        this.value = "Edit";
        DOC("MSG_IFRAME").classList.remove("hide");
        DOC("MSG_INPUT").classList.add("hide");
    } else {
        this.value = "View";
        DOC("MSG_IFRAME").classList.add("hide");
        DOC("MSG_INPUT").classList.remove("hide");
    }
};
// 
DOC("SHOW_MSG_CONT").onclick = function () {
    DOC("DBG_CONT").classList.add("hide");
    DOC("DBG_MENU").classList.add("hide");
    DOC("MSG_CONTAINER").classList.remove("hide");
    DOC("MSG_MENU").classList.remove("hide");
}
DOC("SHOW_DBG_CONT").onclick = function () {
    DOC("MSG_CONTAINER").classList.add("hide");
    DOC("MSG_MENU").classList.add("hide");
    DOC("DBG_CONT").classList.remove("hide");
    DOC("DBG_MENU").classList.remove("hide");
}
// 
var XHR = function (data, async, file, callback) {
    var xhr = new XMLHttpRequest();
    xhr.open("POST", file, async);
    xhr.setRequestHeader("Cache-Control", "no-cache");
    xhr.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
    xhr.onload = function () {
        if (xhr.response !== "") {
            callback(xhr.response);
        }
    };
    xhr.send(data);
}
// 
function DOC(ID) {
    return document.getElementById(ID);
}
// 
var TIMER;
function NOTIFY(STRING) {

    DOC("NOTIFICATION").classList.remove("hide");
    if (TIMER !== null) {
        clearTimeout(TIMER);
        DOC("NOTIFICATION").innerHTML += STRING + "<br>";
    } else { DOC("NOTIFICATION").innerHTML = STRING; }
    TIMER = setTimeout(() => {
        DOC("NOTIFICATION").classList.add("hide"); DOC("NOTIFICATION").innerHTML = '';
    }, 1000);
}

DOC("MSG_CLEAN").onclick = function () {

    var content = DOC("MSG_INPUT").value;

    content = decodeHtml(content);
    content = content.replace(/<\!--.*?-->/g, "");
    content = content.replace(/[\n\r]+/g, "\n");

    DOC("MSG_INPUT").value = content;

};

function decodeHtml(html) {
    var txt = document.createElement("textarea");
    txt.innerHTML = html;
    return txt.value;
}